-- @author Pablo Garcia Sanz
-- Scrypt Base de Datos de Judocup
-- Mysql

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Base de datos: `judocupv2`
--

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `arbitroatatami`
--

CREATE TABLE `arbitroatatami` (
  `idTatami` int(11) NOT NULL,
  `dniArbitro` char(30) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `categoriaarbitral`
--

CREATE TABLE `categoriaarbitral` (
  `idCategoriaArbitral` int(11) NOT NULL,
  `descripcion` char(30) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `categoriaarbitral`
--

INSERT INTO `categoriaarbitral` (`idCategoriaArbitral`, `descripcion`) VALUES
(1, 'Provincial'),
(2, 'Regional'),
(3, 'Nacional C'),
(4, 'Nacional B'),
(5, 'Nacional A'),
(6, 'Continental'),
(7, 'Internacional');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `combate`
--

CREATE TABLE `combate` (
  `idCombate` int(11) NOT NULL,
  `tiempo` int(11) DEFAULT NULL,
  `fase` char(30) DEFAULT NULL,
  `idTatami` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `competicion`
--

CREATE TABLE `competicion` (
  `idCompeticion` int(11) NOT NULL,
  `nombre` char(30) NOT NULL,
  `fecha` date NOT NULL,
  `paisISOA3` char(3) DEFAULT NULL,
  `autonomia` char(30) DEFAULT NULL,
  `provincia` char(30) DEFAULT NULL,
  `pabellon` char(30) DEFAULT NULL,
  `emailDelegado` char(30) DEFAULT NULL,
  `idGrupoEdad` int(11) DEFAULT NULL,
  `idTipoCompeticion` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `cronometrador`
--

CREATE TABLE `cronometrador` (
  `email` varchar(30) NOT NULL,
  `password` varchar(60) NOT NULL,
  `nombre` varchar(30) NOT NULL,
  `apellido1` varchar(30) NOT NULL,
  `apellido2` varchar(30) NOT NULL,
  `dni` varchar(30) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `delegado`
--

CREATE TABLE `delegado` (
  `email` varchar(30) NOT NULL,
  `password` varchar(60) NOT NULL,
  `token` varchar(60) DEFAULT NULL,
  `nombre` varchar(30) DEFAULT NULL,
  `apellido1` varchar(30) DEFAULT NULL,
  `apellido2` varchar(30) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `delegado`
--

INSERT INTO `delegado` (`email`, `password`, `token`, `nombre`, `apellido1`, `apellido2`) VALUES
('judocupapp@gmail.com', '$2y$10$t5mXNatLtgZytmCxu4exKeyfgLiAmAXcnDYD1r/DaHCgI.vesjZGi', '$2y$10$//Wf0ca2Nym2G6TlFRFRu.T8QNhQjufYgJu1zwNogRmEqAuA2vrn2', 'Pablo', 'Garcia', 'Sanz');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `equipo`
--

CREATE TABLE `equipo` (
  `nombre` varchar(30) NOT NULL,
  `directorTecnico` varchar(30) DEFAULT NULL,
  `paisISOA3` char(3) DEFAULT NULL,
  `autonomia` varchar(30) DEFAULT NULL,
  `provincia` varchar(30) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `grupoedad`
--

CREATE TABLE `grupoedad` (
  `idGrupoEdad` int(11) NOT NULL,
  `descripcion` char(30) NOT NULL,
  `edadMinima` int(11) DEFAULT NULL,
  `edadMaxima` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `grupoedad`
--

INSERT INTO `grupoedad` (`idGrupoEdad`, `descripcion`, `edadMinima`, `edadMaxima`) VALUES
(1, 'Benjamin', 9, 10),
(2, 'Alevin', 11, 12),
(3, 'Infantil', 13, 14),
(4, 'Cadete', 15, 17),
(5, 'Junior', 18, 20),
(6, 'Senior', NULL, NULL);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `inscripcion`
--

CREATE TABLE `inscripcion` (
  `idCompeticion` int(11) NOT NULL,
  `dniPersona` varchar(9) NOT NULL,
  `fecha_inscripcion` date NOT NULL,
  `nombreEquipo` varchar(30) DEFAULT NULL,
  `arbitra` bit(1) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `participacion`
--

CREATE TABLE `participacion` (
  `idPeso` int(11) NOT NULL,
  `dniCompetidor` varchar(9) NOT NULL,
  `puesto` int(11) DEFAULT NULL,
  `fecha_participacion` date NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `persona`
--

CREATE TABLE `persona` (
  `dni` varchar(9) NOT NULL,
  `nombre` varchar(30) NOT NULL,
  `apellido1` varchar(30) NOT NULL,
  `apellido2` varchar(30) DEFAULT NULL,
  `paisISOA3` char(3) DEFAULT NULL,
  `autonomia` varchar(30) DEFAULT NULL,
  `provincia` varchar(30) DEFAULT NULL,
  `idCategoriaArbitral` int(11) DEFAULT NULL,
  `email` varchar(30) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `peso`
--

CREATE TABLE `peso` (
  `idPeso` int(11) NOT NULL,
  `descripcion` varchar(11) NOT NULL,
  `sexo` char(1) NOT NULL,
  `idGrupoEdad` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `peso`
--

INSERT INTO `peso` (`idPeso`, `descripcion`, `sexo`, `idGrupoEdad`) VALUES
(1, '-60', 'M', 6),
(2, '-66', 'M', 6),
(3, '-73', 'M', 6),
(4, '-81', 'M', 6),
(5, '-90', 'M', 6),
(6, '-100', 'M', 6),
(7, '+100', 'M', 6),
(8, '-48', 'F', 6),
(9, '-52', 'F', 6),
(10, '-57', 'F', 6),
(11, '-63', 'F', 6),
(12, '-70', 'F', 6),
(13, '-78', 'F', 6),
(14, '+78', 'F', 6),
(15, '-55', 'M', 5),
(16, '-60', 'M', 5),
(17, '-66', 'M', 5),
(18, '-73', 'M', 5),
(19, '-81', 'M', 5),
(20, '-90', 'M', 5),
(21, '-100', 'M', 5),
(22, '-44', 'F', 5),
(23, '-48', 'F', 5),
(24, '-52', 'F', 5),
(25, '-57', 'F', 5),
(26, '-63', 'F', 5),
(27, '-70', 'F', 5),
(28, '-78', 'F', 5),
(29, '+78', 'F', 5),
(30, '-46', 'M', 4),
(31, '-50', 'M', 4),
(32, '-55', 'M', 4),
(33, '-60', 'M', 4),
(34, '-66', 'M', 4),
(35, '-73', 'M', 4),
(36, '-81', 'M', 4),
(37, '-90', 'M', 4),
(38, '+90', 'M', 4),
(39, '-40', 'F', 4),
(40, '-44', 'F', 4),
(41, '-48', 'F', 4),
(42, '-52', 'F', 4),
(43, '-57', 'F', 4),
(44, '-63', 'F', 4),
(45, '-70', 'F', 4),
(46, '+70', 'F', 4),
(47, '-34', 'M', 3),
(48, '-38', 'M', 3),
(49, '-42', 'M', 3),
(50, '-46', 'M', 3),
(51, '-50', 'M', 3),
(52, '-55', 'M', 3),
(53, '-60', 'M', 3),
(54, '-66', 'M', 3),
(55, '-73', 'M', 3),
(56, '+73', 'M', 3),
(57, '-36', 'F', 3),
(58, '-40', 'F', 3),
(59, '-44', 'F', 3),
(60, '-48', 'F', 3),
(61, '-52', 'F', 3),
(62, '-57', 'F', 3),
(63, '-63', 'F', 3),
(64, '-70', 'F', 3),
(65, '+70', 'F', 3),
(66, '-30', 'M', 2),
(67, '-34', 'M', 2),
(68, '-38', 'M', 2),
(69, '-42', 'M', 2),
(70, '-46', 'M', 2),
(71, '-50', 'M', 2),
(72, '-55', 'M', 2),
(73, '-60', 'M', 2),
(74, '-66', 'M', 2),
(75, '+66', 'M', 2),
(76, '-32', 'F', 2),
(77, '-36', 'F', 2),
(78, '-40', 'F', 2),
(79, '-44', 'F', 2),
(80, '-48', 'F', 2),
(81, '-52', 'F', 2),
(82, '-57', 'F', 2),
(83, '-63', 'F', 2),
(84, '+63', 'F', 2),
(85, '-32', 'M', 1),
(86, '+100', 'M', 5);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `puntuacion`
--

CREATE TABLE `puntuacion` (
  `idCombate` int(11) NOT NULL,
  `dniCompetidor` char(30) NOT NULL,
  `ippon` smallint(6) DEFAULT NULL,
  `waza_ari` smallint(6) DEFAULT NULL,
  `shido` smallint(6) DEFAULT NULL,
  `hansokumake` smallint(6) DEFAULT NULL,
  `color_kimono` varchar(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `tatami`
--

CREATE TABLE `tatami` (
  `idTatami` int(11) NOT NULL,
  `numero` int(11) NOT NULL,
  `idCompeticion` int(11) NOT NULL,
  `emailCronometrador` varchar(30) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `tipocompeticion`
--

CREATE TABLE `tipocompeticion` (
  `idTipoCompeticion` int(11) NOT NULL,
  `descripcion` varchar(30) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `tipocompeticion`
--

INSERT INTO `tipocompeticion` (`idTipoCompeticion`, `descripcion`) VALUES
(1, 'Provincial'),
(2, 'Regional'),
(3, 'Nacional'),
(4, 'Sector');

--
-- Indices para tablas volcadas
--

--
-- Indices de la tabla `arbitroatatami`
--
ALTER TABLE `arbitroatatami`
  ADD PRIMARY KEY (`idTatami`,`dniArbitro`),
  ADD KEY `dniArbitro` (`dniArbitro`);

--
-- Indices de la tabla `categoriaarbitral`
--
ALTER TABLE `categoriaarbitral`
  ADD PRIMARY KEY (`idCategoriaArbitral`);

--
-- Indices de la tabla `combate`
--
ALTER TABLE `combate`
  ADD PRIMARY KEY (`idCombate`),
  ADD KEY `idTatami` (`idTatami`);

--
-- Indices de la tabla `competicion`
--
ALTER TABLE `competicion`
  ADD PRIMARY KEY (`idCompeticion`),
  ADD KEY `emailDelegado` (`emailDelegado`),
  ADD KEY `grupoEdad` (`idGrupoEdad`),
  ADD KEY `idTipoCompeticion` (`idTipoCompeticion`);

--
-- Indices de la tabla `cronometrador`
--
ALTER TABLE `cronometrador`
  ADD PRIMARY KEY (`email`);

--
-- Indices de la tabla `delegado`
--
ALTER TABLE `delegado`
  ADD PRIMARY KEY (`email`);

--
-- Indices de la tabla `equipo`
--
ALTER TABLE `equipo`
  ADD PRIMARY KEY (`nombre`);

--
-- Indices de la tabla `grupoedad`
--
ALTER TABLE `grupoedad`
  ADD PRIMARY KEY (`idGrupoEdad`);

--
-- Indices de la tabla `inscripcion`
--
ALTER TABLE `inscripcion`
  ADD PRIMARY KEY (`dniPersona`,`idCompeticion`),
  ADD KEY `nombreEquipo` (`nombreEquipo`),
  ADD KEY `idCompeticion` (`idCompeticion`);

--
-- Indices de la tabla `participacion`
--
ALTER TABLE `participacion`
  ADD PRIMARY KEY (`idPeso`,`dniCompetidor`,`fecha_participacion`),
  ADD KEY `dniCompetidor` (`dniCompetidor`);

--
-- Indices de la tabla `persona`
--
ALTER TABLE `persona`
  ADD PRIMARY KEY (`dni`),
  ADD KEY `idCategoriaArbitral` (`idCategoriaArbitral`);

--
-- Indices de la tabla `peso`
--
ALTER TABLE `peso`
  ADD PRIMARY KEY (`idPeso`),
  ADD KEY `idGrupoEdad` (`idGrupoEdad`);

--
-- Indices de la tabla `puntuacion`
--
ALTER TABLE `puntuacion`
  ADD PRIMARY KEY (`idCombate`,`dniCompetidor`),
  ADD KEY `dniCompetidor` (`dniCompetidor`);

--
-- Indices de la tabla `tatami`
--
ALTER TABLE `tatami`
  ADD PRIMARY KEY (`idTatami`),
  ADD KEY `idCompeticion` (`idCompeticion`),
  ADD KEY `emailCronometrador` (`emailCronometrador`);

--
-- Indices de la tabla `tipocompeticion`
--
ALTER TABLE `tipocompeticion`
  ADD PRIMARY KEY (`idTipoCompeticion`);

--
-- AUTO_INCREMENT de las tablas volcadas
--

--
-- AUTO_INCREMENT de la tabla `categoriaarbitral`
--
ALTER TABLE `categoriaarbitral`
  MODIFY `idCategoriaArbitral` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;
--
-- AUTO_INCREMENT de la tabla `combate`
--
ALTER TABLE `combate`
  MODIFY `idCombate` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;
--
-- AUTO_INCREMENT de la tabla `competicion`
--
ALTER TABLE `competicion`
  MODIFY `idCompeticion` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;
--
-- AUTO_INCREMENT de la tabla `grupoedad`
--
ALTER TABLE `grupoedad`
  MODIFY `idGrupoEdad` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;
--
-- AUTO_INCREMENT de la tabla `peso`
--
ALTER TABLE `peso`
  MODIFY `idPeso` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=87;
--
-- AUTO_INCREMENT de la tabla `tatami`
--
ALTER TABLE `tatami`
  MODIFY `idTatami` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=39;
--
-- AUTO_INCREMENT de la tabla `tipocompeticion`
--
ALTER TABLE `tipocompeticion`
  MODIFY `idTipoCompeticion` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;
--
-- Restricciones para tablas volcadas
--

--
-- Filtros para la tabla `arbitroatatami`
--
ALTER TABLE `arbitroatatami`
  ADD CONSTRAINT `arbitroatatami_ibfk_1` FOREIGN KEY (`idTatami`) REFERENCES `tatami` (`idTatami`) ON DELETE CASCADE,
  ADD CONSTRAINT `arbitroatatami_ibfk_2` FOREIGN KEY (`dniArbitro`) REFERENCES `persona` (`dni`) ON DELETE CASCADE;

--
-- Filtros para la tabla `combate`
--
ALTER TABLE `combate`
  ADD CONSTRAINT `combate_ibfk_1` FOREIGN KEY (`idTatami`) REFERENCES `tatami` (`idTatami`) ON DELETE CASCADE;

--
-- Filtros para la tabla `competicion`
--
ALTER TABLE `competicion`
  ADD CONSTRAINT `competicion_ibfk_1` FOREIGN KEY (`emailDelegado`) REFERENCES `delegado` (`email`),
  ADD CONSTRAINT `competicion_ibfk_2` FOREIGN KEY (`idGrupoEdad`) REFERENCES `grupoedad` (`idGrupoEdad`),
  ADD CONSTRAINT `competicion_ibfk_3` FOREIGN KEY (`idTipoCompeticion`) REFERENCES `tipocompeticion` (`idTipoCompeticion`);

--
-- Filtros para la tabla `inscripcion`
--
ALTER TABLE `inscripcion`
  ADD CONSTRAINT `inscripcion_ibfk_1` FOREIGN KEY (`dniPersona`) REFERENCES `persona` (`dni`) ON DELETE CASCADE ON UPDATE NO ACTION,
  ADD CONSTRAINT `inscripcion_ibfk_2` FOREIGN KEY (`nombreEquipo`) REFERENCES `equipo` (`nombre`) ON DELETE SET NULL ON UPDATE NO ACTION,
  ADD CONSTRAINT `inscripcion_ibfk_3` FOREIGN KEY (`idCompeticion`) REFERENCES `competicion` (`idCompeticion`) ON DELETE CASCADE ON UPDATE NO ACTION;

--
-- Filtros para la tabla `participacion`
--
ALTER TABLE `participacion`
  ADD CONSTRAINT `participacion_ibfk_1` FOREIGN KEY (`idPeso`) REFERENCES `peso` (`idPeso`) ON DELETE CASCADE ON UPDATE NO ACTION,
  ADD CONSTRAINT `participacion_ibfk_2` FOREIGN KEY (`dniCompetidor`) REFERENCES `persona` (`dni`) ON DELETE CASCADE ON UPDATE NO ACTION;

--
-- Filtros para la tabla `persona`
--
ALTER TABLE `persona`
  ADD CONSTRAINT `persona_ibfk_1` FOREIGN KEY (`idCategoriaArbitral`) REFERENCES `categoriaarbitral` (`idCategoriaArbitral`) ON DELETE SET NULL ON UPDATE NO ACTION;

--
-- Filtros para la tabla `peso`
--
ALTER TABLE `peso`
  ADD CONSTRAINT `peso_ibfk_1` FOREIGN KEY (`idGrupoEdad`) REFERENCES `grupoedad` (`idGrupoEdad`) ON DELETE CASCADE ON UPDATE NO ACTION;

--
-- Filtros para la tabla `puntuacion`
--
ALTER TABLE `puntuacion`
  ADD CONSTRAINT `puntuacion_ibfk_1` FOREIGN KEY (`idCombate`) REFERENCES `combate` (`idCombate`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `puntuacion_ibfk_2` FOREIGN KEY (`dniCompetidor`) REFERENCES `persona` (`dni`) ON DELETE CASCADE ON UPDATE NO ACTION;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;

